<div class="bg-white rounded-3xl shadow-sm px-6 sm:px-10 py-12">
    <article class="article-content">

        <p class="lead">
            Few dishes carry the regal charm, aromatic richness, and comforting warmth of Korma. Synonymous with North Indian, Mughlai, and South Asian cuisine, Korma is a creamy, mildly spiced curry that has been delighting palates for centuries. Its luxurious texture, aromatic spices, and melt-in-your-mouth flavors make it a dish that is both festive and comforting—a true testament to the culinary heritage of the Indian subcontinent.
        </p>

        <hr>

        <h2>What is Korma?</h2>
        <p>
            Korma is a slow-cooked curry, traditionally made with meat (like chicken, lamb, or beef), vegetables, or paneer, braised in a blend of yogurt, cream, nuts, and aromatic spices. Unlike fiery curries, Korma is known for its mild, creamy, and subtly spiced profile, making it accessible even to those who shy away from intense heat.
        </p>
        <p>
            The term “Korma” comes from the Urdu word “qormā”, meaning “braise,” which reflects the slow-cooked, tender preparation method that allows flavors to meld beautifully.
        </p>

        <hr>

        <h2>The Rich History of Korma</h2>
        <p>
            Korma has roots in Mughlai cuisine, developed during the Mughal era in India (16th-19th century). The Mughal emperors favored rich, aromatic dishes, often using nuts, cream, ghee (clarified butter), and exotic spices to create royal feasts.
        </p>
        <p>
            Over time, Korma spread across India, Pakistan, Bangladesh, and even Southeast Asia, with regional variations adapting to local tastes and ingredients. From the mild, yogurt-based Kormas of Delhi to the coconut-infused Kormas of South India, this dish embodies the diversity and creativity of South Asian cuisine.
        </p>

        <hr>

        <h2>Ingredients: The Heart of Korma</h2>
        <ul>
            <li><strong>Meat or vegetables:</strong> Chicken, lamb, beef, paneer, or mixed vegetables</li>
            <li><strong>Yogurt or cream:</strong> Provides the signature creamy texture</li>
            <li><strong>Nuts:</strong> Cashews or almonds, often ground into a paste to thicken the curry</li>
            <li><strong>Spices:</strong> Cardamom, cinnamon, cloves, cumin, coriander, turmeric, and sometimes saffron</li>
            <li><strong>Ghee or oil:</strong> For richness and depth</li>
            <li><strong>Aromatics:</strong> Onions, garlic, and ginger, sautéed to create the flavor base</li>
            <li><strong>Optional:</strong> Coconut milk, cream, or tomatoes for regional variations</li>
        </ul>

        <hr>

        <h2>How Korma is Traditionally Made</h2>
        <ol>
            <li>Prepare a spice base: Sauté onions, garlic, and ginger until golden.</li>
            <li>Add spices: Toast aromatic spices to release their full flavor.</li>
            <li>Incorporate meat or vegetables: Brown them lightly in the spice base.</li>
            <li>Add yogurt, cream, or nut paste: Simmer slowly to tenderize meat and create a creamy sauce.</li>
            <li>Finish with garnishes: Whole spices, fried onions, coriander leaves, or saffron for aroma and visual appeal.</li>
        </ol>
        <p>
            The slow-cooking method ensures that every bite is infused with flavor, resulting in tender, melt-in-your-mouth textures.
        </p>

        <hr>

        <h2>Types of Korma</h2>
        <ul>
            <li><strong>Chicken Korma:</strong> Mild, creamy, often flavored with cashew paste and yogurt</li>
            <li><strong>Lamb or Goat Korma:</strong> Rich, hearty, deeply aromatic, perfect for festive meals</li>
            <li><strong>Vegetable Korma:</strong> A vegetarian delight using seasonal vegetables, paneer, or tofu</li>
            <li><strong>South Indian Korma:</strong> Often coconut-based, slightly sweeter, and uses local spices</li>
            <li><strong>Mughlai Korma:</strong> Classic royal version with cream, nuts, and saffron</li>
        </ul>

        <hr>

        <h2>Serving Korma</h2>
        <p>
            Korma pairs beautifully with naan, roti, paratha, or steamed rice. Its creamy texture balances perfectly with flatbreads, while the subtle spices enhance the natural flavors of the meat or vegetables. For a festive touch, Korma is often served with pickles, raita, or fried onions on the side.
        </p>

        <hr>

        <h2>Health and Nutrition</h2>
        <ul>
            <li>Using yogurt instead of cream reduces fat content</li>
            <li>Lean meats like chicken or lamb make it protein-rich</li>
            <li>Adding vegetables boosts fiber, vitamins, and minerals</li>
            <li>Moderating ghee or oil keeps it lighter without sacrificing flavor</li>
        </ul>
        <p>
            With mindful preparation, Korma can be a nourishing yet luxurious meal suitable for family dinners or special occasions.
        </p>

        <hr>

        <h2>Korma Around the World</h2>
        <p>
            Korma has transcended borders and found a place in global cuisine. In the UK, “Korma” often refers to a mild, creamy curry served in Indian restaurants. In Southeast Asia, local versions incorporate coconut milk and regional spices, giving it a tropical twist. Its adaptability, gentle flavors, and luxurious texture make it a favorite for both home cooks and chefs worldwide.
        </p>

        <hr>

        <div class="conclusion-box">
            <p>
                Korma is more than just a curry—it’s a celebration of flavor, culture, and culinary artistry. Its creamy sauce, aromatic spices, and tender meat or vegetables embody centuries of South Asian tradition while remaining versatile for modern kitchens.
            </p>
            <p>
                Whether enjoyed at a festive gathering or as a comforting weeknight dinner, Korma delivers elegance, warmth, and indulgence in every bite. For anyone exploring Indian or South Asian cuisine, Korma is a must-try—a dish that showcases how simplicity, technique, and premium ingredients can come together to create a timeless classic.
            </p>
        </div>

    </article>
</div>